/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.util.DummyContainer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemTagMatcher;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class DroneAICrafting
extends Goal {
    private final ICraftingWidget widget;
    private final IDroneBase drone;
    private final int maxActions;
    private int actionCount;

    public DroneAICrafting(IDroneBase drone, ICraftingWidget widget) {
        this.drone = drone;
        this.widget = widget;
        this.maxActions = widget.useCount() ? widget.getCount() : 0;
        this.actionCount = 0;
    }

    public boolean m_8036_() {
        if (this.maxActions > 0 && this.actionCount >= this.maxActions) {
            return false;
        }
        CraftingContainer craftingGrid = this.widget.getCraftingGrid();
        return this.widget.getRecipe(this.drone.world(), craftingGrid).map(recipe -> {
            List<List<ItemStack>> equivalentsList = this.buildEquivalentsList(craftingGrid);
            if (equivalentsList.isEmpty()) {
                return false;
            }
            int[] equivIndices = new int[9];
            CraftingContainer craftMatrix = new CraftingContainer((AbstractContainerMenu)new DummyContainer(), 3, 3);
            do {
                for (int i = 0; i < equivalentsList.size(); ++i) {
                    ItemStack stack = equivalentsList.get(i).isEmpty() ? ItemStack.f_41583_ : equivalentsList.get(i).get(equivIndices[i]);
                    craftMatrix.m_6836_(i, stack);
                }
                if (!recipe.m_5818_((Container)craftMatrix, this.drone.world()) || !this.doCrafting(recipe.m_5874_((Container)craftMatrix), craftMatrix)) continue;
                ++this.actionCount;
                return true;
            } while (this.count(equivIndices, equivalentsList));
            return false;
        }).orElse(false);
    }

    private List<List<ItemStack>> buildEquivalentsList(CraftingContainer craftingGrid) {
        ArrayList<List<ItemStack>> equivalentsList = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < craftingGrid.m_6643_(); ++i) {
            equivalentsList.add(new ArrayList());
            ItemStack recipeStack = craftingGrid.m_8020_(i);
            if (recipeStack.m_41619_()) continue;
            ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
            for (int j = 0; j < this.drone.getInv().getSlots(); ++j) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(j);
                if (droneStack.m_41619_() || droneStack.m_41720_() != recipeStack.m_41720_() && !ItemTagMatcher.matchTags(droneStack, recipeStack)) continue;
                equivalents.add(droneStack);
            }
            if (equivalents.isEmpty()) {
                return Collections.emptyList();
            }
            ((List)equivalentsList.get(i)).addAll(equivalents);
        }
        return equivalentsList;
    }

    private boolean count(int[] curIndexes, List<List<ItemStack>> equivalentsList) {
        for (int i = 0; i < equivalentsList.size(); ++i) {
            List<ItemStack> list = equivalentsList.get(i);
            int n = i;
            curIndexes[n] = curIndexes[n] + 1;
            if (!list.isEmpty() && curIndexes[i] < list.size()) {
                return true;
            }
            curIndexes[i] = 0;
        }
        return false;
    }

    public boolean doCrafting(ItemStack craftedStack, CraftingContainer craftMatrix) {
        int i;
        for (i = 0; i < craftMatrix.m_6643_(); ++i) {
            int requiredCount = 0;
            ItemStack stack = craftMatrix.m_8020_(i);
            if (stack.m_41619_()) continue;
            for (int j = 0; j < craftMatrix.m_6643_(); ++j) {
                if (stack != craftMatrix.m_8020_(j)) continue;
                ++requiredCount;
            }
            if (requiredCount <= stack.m_41613_()) continue;
            return false;
        }
        ForgeEventFactory.firePlayerCraftingEvent((Player)this.drone.getFakePlayer(), (ItemStack)craftedStack, (Container)craftMatrix);
        for (i = 0; i < craftMatrix.m_6643_(); ++i) {
            ItemStack stack = craftMatrix.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_().hasContainerItem(stack)) {
                ItemStack containerItem = stack.m_41720_().getContainerItem(stack);
                if (!containerItem.m_41619_() && containerItem.m_41763_() && containerItem.m_41773_() > containerItem.m_41776_()) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((Player)this.drone.getFakePlayer(), containerItem, InteractionHand.MAIN_HAND));
                    continue;
                }
                IOHelper.insertOrDrop(this.drone.world(), containerItem, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
            }
            stack.m_41774_(1);
        }
        for (i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.m_41613_() > 0) continue;
            this.drone.getInv().setStackInSlot(i, ItemStack.f_41583_);
        }
        IOHelper.insertOrDrop(this.drone.world(), craftedStack, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
        return true;
    }
}

